<h1 class="mb-4">Přidat zákazníka</h1>

<form method="post" action="" class="needs-validation" novalidate>
    <div class="mb-3">
        <label for="name" class="form-label">Jméno:</label>
        <input id="name" name="name" type="text" class="form-control" required>
        <div class="invalid-feedback">
            Prosím, zadejte jméno zákazníka.
        </div>
    </div>

    <div class="mb-3">
        <label for="email" class="form-label">Email:</label>
        <input id="email" name="email" type="email" class="form-control" required>
        <div class="invalid-feedback">
            Prosím, zadejte platnou emailovou adresu.
        </div>
    </div>

    <div class="mb-3">
        <label for="phone" class="form-label">Telefon:</label>
        <input id="phone" name="phone" type="text" class="form-control" required>
        <div class="invalid-feedback">
            Prosím, zadejte telefonní číslo.
        </div>
    </div>

    <div class="mb-3">
        <label for="address" class="form-label">Adresa:</label>
        <input id="address" name="address" type="text" class="form-control" required>
        <div class="invalid-feedback">
            Prosím, zadejte adresu.
        </div>
    </div>

    <div class="d-flex justify-content-between mt-4">
        <button type="submit" class="btn btn-success"><i class="bi bi-check-lg"></i></button>
        <a href="?controller=customer&action=index" class="btn btn-secondary"><i class="bi bi-arrow-left"></i></a>
    </div>
</form>

<script>
    (function() {
        'use strict'
        var forms = document.querySelectorAll('.needs-validation')

        Array.prototype.slice.call(forms)
        .forEach(function (form) {
            form.addEventListener('submit', function (event) {
                if (!form.checkValidity()) {
                    event.preventDefault()
                    event.stopPropagation()
                }
                form.classList.add('was-validated')
            }, false)
        })
    })()
</script>
